/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.dyeable_redstone_signal.common.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.hexagram2021.dyeable_redstone_signal.common.block.ColorfulRedstoneWireBlock;
import com.hexagram2021.dyeable_redstone_signal.common.block.CommonRedstoneRepeater;
import com.hexagram2021.dyeable_redstone_signal.common.block.CommonRedstoneWireBlock;
import com.hexagram2021.dyeable_redstone_signal.common.block.entity.CommonRedstoneRepeaterBlockEntity;
import com.hexagram2021.dyeable_redstone_signal.common.block.entity.CommonRedstoneWireBlockEntity;
import com.hexagram2021.dyeable_redstone_signal.common.register.DRSBlocks;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class RedstoneWireBlock
extends Block {
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.f_61383_;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.f_61382_;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.f_61384_;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.f_61385_;
    public static final Map<Direction, EnumProperty<RedstoneSide>> PROPERTY_BY_DIRECTION = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, NORTH, (Object)Direction.EAST, EAST, (Object)Direction.SOUTH, SOUTH, (Object)Direction.WEST, WEST));
    protected static final int H = 1;
    protected static final int W = 3;
    protected static final int E = 13;
    protected static final int N = 3;
    protected static final int S = 13;
    private static final VoxelShape SHAPE_DOT = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final Map<Direction, VoxelShape> SHAPES_FLOOR = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0)));
    private static final Map<Direction, VoxelShape> SHAPES_UP = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.m_83110_((VoxelShape)SHAPES_FLOOR.get(Direction.NORTH), (VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)1.0)), (Object)Direction.SOUTH, (Object)Shapes.m_83110_((VoxelShape)SHAPES_FLOOR.get(Direction.SOUTH), (VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)15.0, (double)13.0, (double)16.0, (double)16.0)), (Object)Direction.EAST, (Object)Shapes.m_83110_((VoxelShape)SHAPES_FLOOR.get(Direction.EAST), (VoxelShape)Block.m_49796_((double)15.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0)), (Object)Direction.WEST, (Object)Shapes.m_83110_((VoxelShape)SHAPES_FLOOR.get(Direction.WEST), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)1.0, (double)16.0, (double)13.0))));
    private static final Map<ShapeType, VoxelShape> SHAPES_CACHE = Maps.newHashMap();
    private static final float PARTICLE_DENSITY = 0.2f;
    private final BlockState crossState;
    private boolean shouldSignal = true;

    private static VoxelShape calculateShape(ShapeType shapeType) {
        VoxelShape voxelshape = SHAPE_DOT;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = shapeType.getDirectionRedstoneSide(direction);
            if (redstoneside == RedstoneSide.SIDE) {
                voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)SHAPES_FLOOR.get(direction));
                continue;
            }
            if (redstoneside != RedstoneSide.UP) continue;
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)SHAPES_UP.get(direction));
        }
        return voxelshape;
    }

    protected BlockState getDefaultState() {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(NORTH, (Comparable)RedstoneSide.NONE)).m_61124_(EAST, (Comparable)RedstoneSide.NONE)).m_61124_(SOUTH, (Comparable)RedstoneSide.NONE)).m_61124_(WEST, (Comparable)RedstoneSide.NONE);
    }

    public RedstoneWireBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_(this.getDefaultState());
        this.crossState = (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(NORTH, (Comparable)RedstoneSide.SIDE)).m_61124_(EAST, (Comparable)RedstoneSide.SIDE)).m_61124_(SOUTH, (Comparable)RedstoneSide.SIDE)).m_61124_(WEST, (Comparable)RedstoneSide.SIDE);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        return SHAPES_CACHE.get(new ShapeType(blockState));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getConnectionState((BlockGetter)context.m_43725_(), this.crossState, context.m_8083_());
    }

    public BlockState defaultBlockStateWithPower(BlockState blockState) {
        return this.m_49966_();
    }

    public BlockState crossStateWithPower(BlockState blockState) {
        return this.crossState;
    }

    private BlockState getConnectionState(BlockGetter level, BlockState blockState, BlockPos blockPos) {
        boolean x_unconnected;
        boolean flag = RedstoneWireBlock.isDot(blockState);
        blockState = this.getMissingConnections(level, this.defaultBlockStateWithPower(blockState), blockPos);
        if (flag && RedstoneWireBlock.isDot(blockState)) {
            return blockState;
        }
        boolean north_connected = ((RedstoneSide)blockState.m_61143_(NORTH)).m_61761_();
        boolean south_connected = ((RedstoneSide)blockState.m_61143_(SOUTH)).m_61761_();
        boolean east_connected = ((RedstoneSide)blockState.m_61143_(EAST)).m_61761_();
        boolean west_connected = ((RedstoneSide)blockState.m_61143_(WEST)).m_61761_();
        boolean z_unconnected = !north_connected && !south_connected;
        boolean bl = x_unconnected = !east_connected && !west_connected;
        if (!west_connected && z_unconnected) {
            blockState = (BlockState)blockState.m_61124_(WEST, (Comparable)RedstoneSide.SIDE);
        }
        if (!east_connected && z_unconnected) {
            blockState = (BlockState)blockState.m_61124_(EAST, (Comparable)RedstoneSide.SIDE);
        }
        if (!north_connected && x_unconnected) {
            blockState = (BlockState)blockState.m_61124_(NORTH, (Comparable)RedstoneSide.SIDE);
        }
        if (!south_connected && x_unconnected) {
            blockState = (BlockState)blockState.m_61124_(SOUTH, (Comparable)RedstoneSide.SIDE);
        }
        return blockState;
    }

    private BlockState getMissingConnections(BlockGetter level, BlockState blockState, BlockPos blockPos) {
        boolean flag = !level.m_8055_(blockPos.m_7494_()).m_60796_(level, blockPos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (((RedstoneSide)blockState.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction))).m_61761_()) continue;
            RedstoneSide redstoneside = this.getConnectingSide(level, blockPos, direction, flag);
            blockState = (BlockState)blockState.m_61124_((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)redstoneside);
        }
        return blockState;
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState neighbor, LevelAccessor level, BlockPos blockPos, BlockPos neighborBlockPos) {
        if (direction == Direction.DOWN) {
            return blockState;
        }
        if (direction == Direction.UP) {
            return this.getConnectionState((BlockGetter)level, blockState, blockPos);
        }
        RedstoneSide redstoneside = this.getConnectingSide((BlockGetter)level, blockPos, direction);
        return redstoneside.m_61761_() == ((RedstoneSide)blockState.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction))).m_61761_() && !RedstoneWireBlock.isCross(blockState) ? (BlockState)blockState.m_61124_((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)redstoneside) : this.getConnectionState((BlockGetter)level, (BlockState)this.crossStateWithPower(blockState).m_61124_((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)redstoneside), blockPos);
    }

    private static boolean isCross(BlockState blockState) {
        return ((RedstoneSide)blockState.m_61143_(NORTH)).m_61761_() && ((RedstoneSide)blockState.m_61143_(SOUTH)).m_61761_() && ((RedstoneSide)blockState.m_61143_(EAST)).m_61761_() && ((RedstoneSide)blockState.m_61143_(WEST)).m_61761_();
    }

    private static boolean isDot(BlockState blockState) {
        return !((RedstoneSide)blockState.m_61143_(NORTH)).m_61761_() && !((RedstoneSide)blockState.m_61143_(SOUTH)).m_61761_() && !((RedstoneSide)blockState.m_61143_(EAST)).m_61761_() && !((RedstoneSide)blockState.m_61143_(WEST)).m_61761_();
    }

    protected abstract boolean canConnectWireWith(BlockState var1);

    public void m_7742_(BlockState blockState, LevelAccessor level, BlockPos blockPos, int update, int limit) {
        BlockPos.MutableBlockPos mutableblockpos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)blockState.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction));
            BlockState curBlockState = level.m_8055_((BlockPos)mutableblockpos.m_122159_((Vec3i)blockPos, direction));
            if (redstoneside == RedstoneSide.NONE || this.canConnectWireWith(curBlockState)) continue;
            mutableblockpos.m_122173_(Direction.DOWN);
            BlockState blockstate = level.m_8055_((BlockPos)mutableblockpos);
            if (!blockstate.m_60713_(Blocks.f_50455_)) {
                BlockPos blockpos = mutableblockpos.m_121945_(direction.m_122424_());
                BlockState blockstate1 = blockstate.m_60728_(direction.m_122424_(), level.m_8055_(blockpos), level, (BlockPos)mutableblockpos, blockpos);
                RedstoneWireBlock.m_49908_((BlockState)blockstate, (BlockState)blockstate1, (LevelAccessor)level, (BlockPos)mutableblockpos, (int)update, (int)limit);
            }
            mutableblockpos.m_122159_((Vec3i)blockPos, direction).m_122173_(Direction.UP);
            BlockState blockstate3 = level.m_8055_((BlockPos)mutableblockpos);
            if (blockstate3.m_60713_(Blocks.f_50455_)) continue;
            BlockPos blockpos1 = mutableblockpos.m_121945_(direction.m_122424_());
            BlockState blockstate2 = blockstate3.m_60728_(direction.m_122424_(), level.m_8055_(blockpos1), level, (BlockPos)mutableblockpos, blockpos1);
            RedstoneWireBlock.m_49908_((BlockState)blockstate3, (BlockState)blockstate2, (LevelAccessor)level, (BlockPos)mutableblockpos, (int)update, (int)limit);
        }
    }

    private RedstoneSide getConnectingSide(BlockGetter level, BlockPos blockPos, Direction direction) {
        return this.getConnectingSide(level, blockPos, direction, !level.m_8055_(blockPos.m_7494_()).m_60796_(level, blockPos));
    }

    private RedstoneSide getConnectingSide(BlockGetter level, BlockPos blockPos, Direction direction, boolean goUp) {
        boolean flag;
        BlockPos blockpos = blockPos.m_121945_(direction);
        BlockState blockstate = level.m_8055_(blockpos);
        if (goUp && (flag = this.canSurviveOn(level, blockpos, blockstate)) && this.shouldConnectTo(level.m_8055_(blockpos.m_7494_()), null)) {
            if (blockstate.m_60783_(level, blockpos, direction.m_122424_())) {
                return RedstoneSide.UP;
            }
            return RedstoneSide.SIDE;
        }
        if (this.shouldConnectTo(blockstate, direction)) {
            return RedstoneSide.SIDE;
        }
        if (blockstate.m_60796_(level, blockpos)) {
            return RedstoneSide.NONE;
        }
        BlockPos blockPosBelow = blockpos.m_7495_();
        return this.shouldConnectTo(level.m_8055_(blockPosBelow), null) ? RedstoneSide.SIDE : RedstoneSide.NONE;
    }

    public boolean m_7898_(BlockState blockState, LevelReader level, BlockPos blockPos) {
        BlockPos below = blockPos.m_7495_();
        BlockState belowBlockState = level.m_8055_(below);
        return this.canSurviveOn((BlockGetter)level, below, belowBlockState);
    }

    private boolean canSurviveOn(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState) {
        return blockState.m_60783_(blockGetter, blockPos, Direction.UP) || blockState.m_60713_(Blocks.f_50332_);
    }

    protected abstract void updatePowerStrength(Level var1, BlockPos var2, BlockState var3);

    private void checkCornerChangeAt(Level level, BlockPos blockPos) {
        BlockState blockState = level.m_8055_(blockPos);
        if (this.canConnectWireWith(blockState)) {
            level.m_46672_(blockPos, (Block)this);
            for (Direction direction : Direction.values()) {
                level.m_46672_(blockPos.m_121945_(direction), (Block)this);
            }
        }
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState neighbor, boolean update) {
        if (!(neighbor.m_60713_(blockState.m_60734_()) || neighbor.m_60713_((Block)DRSBlocks.COMMON_REDSTONE_WIRE.get()) || level.f_46443_)) {
            this.updatePowerStrength(level, blockPos, blockState);
            for (Direction direction : Direction.Plane.VERTICAL) {
                level.m_46672_(blockPos.m_121945_(direction), (Block)this);
            }
            this.updateNeighborsOfNeighboringWires(level, blockPos);
        }
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState neighbor, boolean update) {
        if (!(update || blockState.m_60713_(neighbor.m_60734_()) || neighbor.m_60713_((Block)DRSBlocks.COMMON_REDSTONE_WIRE.get()))) {
            super.m_6810_(blockState, level, blockPos, neighbor, false);
            if (!level.f_46443_) {
                for (Direction direction : Direction.values()) {
                    level.m_46672_(blockPos.m_121945_(direction), (Block)this);
                }
                this.updatePowerStrength(level, blockPos, blockState);
                this.updateNeighborsOfNeighboringWires(level, blockPos);
            }
        }
    }

    private void updateNeighborsOfNeighboringWires(Level level, BlockPos blockPos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.checkCornerChangeAt(level, blockPos.m_121945_(direction));
        }
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = blockPos.m_121945_(direction1);
            if (level.m_8055_(blockpos).m_60796_((BlockGetter)level, blockpos)) {
                this.checkCornerChangeAt(level, blockpos.m_7494_());
                continue;
            }
            this.checkCornerChangeAt(level, blockpos.m_7495_());
        }
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos neighborBlockPos, boolean update) {
        if (!level.f_46443_) {
            if (blockState.m_60710_((LevelReader)level, blockPos)) {
                this.updatePowerStrength(level, blockPos, blockState);
            } else {
                RedstoneWireBlock.m_49950_((BlockState)blockState, (Level)level, (BlockPos)blockPos);
                level.m_7471_(blockPos, false);
            }
        }
    }

    public int m_6376_(BlockState blockState, BlockGetter level, BlockPos blockPos, Direction direction) {
        return !this.shouldSignal ? 0 : blockState.m_60746_(level, blockPos, direction);
    }

    public abstract int getPower(BlockState var1);

    protected BlockState setPowerFrom(BlockState blockState, BlockState source) {
        return blockState;
    }

    public int m_6378_(BlockState blockState, BlockGetter level, BlockPos blockPos, Direction direction) {
        if (this.shouldSignal && direction != Direction.DOWN) {
            int i = this.getPower(blockState);
            if (i == 0) {
                return 0;
            }
            return direction != Direction.UP && !((RedstoneSide)this.getConnectionState(level, blockState, blockPos).m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction.m_122424_()))).m_61761_() ? 0 : i;
        }
        return 0;
    }

    protected boolean shouldConnectTo(BlockState other, @Nullable Direction direction) {
        if (other.m_60713_((Block)DRSBlocks.COMMON_REDSTONE_WIRE.get())) {
            return true;
        }
        if (this instanceof CommonRedstoneWireBlock && other.m_60734_() instanceof ColorfulRedstoneWireBlock) {
            return true;
        }
        RedstoneWireBlock redstoneWireBlock = this;
        if (redstoneWireBlock instanceof ColorfulRedstoneWireBlock) {
            ColorfulRedstoneWireBlock colorfulRedstone1 = (ColorfulRedstoneWireBlock)redstoneWireBlock;
            redstoneWireBlock = other.m_60734_();
            if (redstoneWireBlock instanceof ColorfulRedstoneWireBlock) {
                ColorfulRedstoneWireBlock colorfulRedstone2 = (ColorfulRedstoneWireBlock)redstoneWireBlock;
                return colorfulRedstone1.getColorIndex() == colorfulRedstone2.getColorIndex();
            }
        }
        if (other.m_60713_(Blocks.f_50146_) || other.m_60713_((Block)DRSBlocks.COMMON_REDSTONE_REPEATER.get())) {
            Direction facing = (Direction)other.m_61143_((Property)RepeaterBlock.f_54117_);
            return facing == direction || facing.m_122424_() == direction;
        }
        if (other.m_60713_(Blocks.f_50455_)) {
            return direction == other.m_61143_((Property)ObserverBlock.f_52588_);
        }
        return other.m_60803_() && direction != null;
    }

    public boolean m_7899_(BlockState blockState) {
        return this.shouldSignal;
    }

    private void spawnParticlesAlongLine(Level level, RandomSource random, BlockPos blockPos, Vec3 vec3, Direction direction1, Direction direction2, float begin, float end) {
        float f = end - begin;
        if (!(random.m_188501_() >= 0.2f * f)) {
            float f1 = 0.4375f;
            float f2 = begin + f * random.m_188501_();
            double d0 = 0.5 + (double)(f1 * (float)direction1.m_122429_()) + (double)(f2 * (float)direction2.m_122429_());
            double d1 = 0.5 + (double)(f1 * (float)direction1.m_122430_()) + (double)(f2 * (float)direction2.m_122430_());
            double d2 = 0.5 + (double)(f1 * (float)direction1.m_122431_()) + (double)(f2 * (float)direction2.m_122431_());
            level.m_7106_((ParticleOptions)new DustParticleOptions(vec3.m_252839_(), 1.0f), (double)blockPos.m_123341_() + d0, (double)blockPos.m_123342_() + d1, (double)blockPos.m_123343_() + d2, 0.0, 0.0, 0.0);
        }
    }

    protected abstract Vec3 getColor(int var1);

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource random) {
        int i = this.getPower(blockState);
        Vec3 color = this.getColor(i);
        if (i != 0) {
            block4: for (Direction direction : Direction.Plane.HORIZONTAL) {
                RedstoneSide redstoneside = (RedstoneSide)blockState.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction));
                switch (redstoneside) {
                    case UP: {
                        this.spawnParticlesAlongLine(level, random, blockPos, color, direction, Direction.UP, -0.5f, 0.5f);
                    }
                    case SIDE: {
                        this.spawnParticlesAlongLine(level, random, blockPos, color, Direction.DOWN, direction, 0.0f, 0.5f);
                        continue block4;
                    }
                }
                this.spawnParticlesAlongLine(level, random, blockPos, color, Direction.DOWN, direction, 0.0f, 0.3f);
            }
        }
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_(NORTH, (Comparable)((RedstoneSide)blockState.m_61143_(SOUTH)))).m_61124_(EAST, (Comparable)((RedstoneSide)blockState.m_61143_(WEST)))).m_61124_(SOUTH, (Comparable)((RedstoneSide)blockState.m_61143_(NORTH)))).m_61124_(WEST, (Comparable)((RedstoneSide)blockState.m_61143_(EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_(NORTH, (Comparable)((RedstoneSide)blockState.m_61143_(EAST)))).m_61124_(EAST, (Comparable)((RedstoneSide)blockState.m_61143_(SOUTH)))).m_61124_(SOUTH, (Comparable)((RedstoneSide)blockState.m_61143_(WEST)))).m_61124_(WEST, (Comparable)((RedstoneSide)blockState.m_61143_(NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_(NORTH, (Comparable)((RedstoneSide)blockState.m_61143_(WEST)))).m_61124_(EAST, (Comparable)((RedstoneSide)blockState.m_61143_(NORTH)))).m_61124_(SOUTH, (Comparable)((RedstoneSide)blockState.m_61143_(EAST)))).m_61124_(WEST, (Comparable)((RedstoneSide)blockState.m_61143_(SOUTH)));
            default -> blockState;
        };
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)blockState.m_61124_(NORTH, (Comparable)((RedstoneSide)blockState.m_61143_(SOUTH)))).m_61124_(SOUTH, (Comparable)((RedstoneSide)blockState.m_61143_(NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)blockState.m_61124_(EAST, (Comparable)((RedstoneSide)blockState.m_61143_(WEST)))).m_61124_(WEST, (Comparable)((RedstoneSide)blockState.m_61143_(EAST)));
            default -> super.m_6943_(blockState, mirror);
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST});
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult result) {
        if (!player.m_150110_().f_35938_) {
            return InteractionResult.PASS;
        }
        if (RedstoneWireBlock.isCross(blockState) || RedstoneWireBlock.isDot(blockState)) {
            BlockState nextState = RedstoneWireBlock.isCross(blockState) ? this.m_49966_() : this.crossState;
            nextState = this.setPowerFrom(nextState, blockState);
            if ((nextState = this.getConnectionState((BlockGetter)level, nextState, blockPos)) != blockState) {
                level.m_7731_(blockPos, nextState, 3);
                this.updatesOnShapeChange(level, blockPos, blockState, nextState);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void updatesOnShapeChange(Level level, BlockPos blockPos, BlockState blockState, BlockState neighbor) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos relative = blockPos.m_121945_(direction);
            if (((RedstoneSide)blockState.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction))).m_61761_() == ((RedstoneSide)neighbor.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction))).m_61761_() || !level.m_8055_(relative).m_60796_((BlockGetter)level, relative)) continue;
            level.m_46590_(relative, neighbor.m_60734_(), direction.m_122424_());
        }
    }

    protected static int getWireSignal(@Nullable BlockEntity blockEntity, BlockState blockState, int colorIndex, Direction direction) {
        if (blockEntity instanceof CommonRedstoneWireBlockEntity) {
            CommonRedstoneWireBlockEntity wireBlockEntity = (CommonRedstoneWireBlockEntity)blockEntity;
            return wireBlockEntity.getColoredEnergy(colorIndex);
        }
        if (blockEntity instanceof CommonRedstoneRepeaterBlockEntity) {
            CommonRedstoneRepeaterBlockEntity repeaterBlockEntity = (CommonRedstoneRepeaterBlockEntity)blockEntity;
            if (direction == blockState.m_61143_((Property)CommonRedstoneRepeater.f_54117_)) {
                return repeaterBlockEntity.getColoredEnergy(colorIndex) == 0 ? 0 : 16;
            }
            return 0;
        }
        return blockState.m_60713_((Block)DRSBlocks.getColorfulRedstoneWire(colorIndex)) ? ((ColorfulRedstoneWireBlock)blockState.m_60734_()).getColoredEnergy(blockState, colorIndex) : 0;
    }

    static {
        for (RedstoneSide north : RedstoneSide.values()) {
            for (RedstoneSide east : RedstoneSide.values()) {
                for (RedstoneSide south : RedstoneSide.values()) {
                    for (RedstoneSide west : RedstoneSide.values()) {
                        ShapeType shapeType = new ShapeType(north, east, south, west);
                        SHAPES_CACHE.put(shapeType, RedstoneWireBlock.calculateShape(shapeType));
                    }
                }
            }
        }
    }

    static class ShapeType {
        private final RedstoneSide NORTH;
        private final RedstoneSide EAST;
        private final RedstoneSide SOUTH;
        private final RedstoneSide WEST;

        public ShapeType(RedstoneSide north, RedstoneSide east, RedstoneSide south, RedstoneSide west) {
            this.NORTH = north;
            this.EAST = east;
            this.SOUTH = south;
            this.WEST = west;
        }

        public ShapeType(BlockState blockState) {
            this.NORTH = (RedstoneSide)blockState.m_61143_(NORTH);
            this.EAST = (RedstoneSide)blockState.m_61143_(EAST);
            this.SOUTH = (RedstoneSide)blockState.m_61143_(SOUTH);
            this.WEST = (RedstoneSide)blockState.m_61143_(WEST);
        }

        public boolean equals(Object object) {
            if (object instanceof ShapeType) {
                ShapeType shapeType = (ShapeType)object;
                return this.NORTH == shapeType.NORTH && this.EAST == shapeType.EAST && this.SOUTH == shapeType.SOUTH && this.WEST == shapeType.WEST;
            }
            return false;
        }

        public int hashCode() {
            return this.NORTH.ordinal() * 64 + this.EAST.ordinal() * 16 + this.SOUTH.ordinal() * 4 + this.WEST.ordinal();
        }

        @Nullable
        public RedstoneSide getDirectionRedstoneSide(Direction direction) {
            return switch (direction) {
                case Direction.NORTH -> this.NORTH;
                case Direction.EAST -> this.EAST;
                case Direction.SOUTH -> this.SOUTH;
                case Direction.WEST -> this.WEST;
                default -> null;
            };
        }
    }
}

